/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.GenericObjectNode;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Item;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import net.n3.nanoxml.IXMLElement;

public abstract class AbstractItemXml
implements Item {
    protected Item parent;
    protected IXMLElement path;
    protected I18N i18n = Application.getI18n();
    protected ArrayList<Item> childs = new ArrayList();
    private Action action = null;
    private boolean enabled = true;

    AbstractItemXml(Item parent, IXMLElement path, I18N i18n) {
        String s;
        this.parent = parent;
        this.path = path;
        if (i18n != null) {
            this.i18n = i18n;
        }
        this.enabled = (s = path.getAttribute("enabled", null)) == null || s.equalsIgnoreCase("true");
    }

    @Override
    public String getName() {
        String name = this.path.getAttribute("name", null);
        return name == null ? null : this.i18n.tr(name);
    }

    @Override
    public boolean isEnabled() throws RemoteException {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled, boolean recursive) throws RemoteException {
        this.enabled = enabled;
    }

    @Override
    public Action getAction() {
        if (this.action != null) {
            return this.action;
        }
        String s = this.path.getAttribute("action", null);
        if (s == null) {
            return null;
        }
        try {
            Class c = Application.getClassLoader().load(s);
            BeanService beanService = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            this.action = (Action)beanService.get(c);
            return this.action;
        }
        catch (Exception e) {
            Logger.error((String)("error while instantiating action " + s), (Throwable)e);
            return null;
        }
    }

    public GenericIterator getChildren() throws RemoteException {
        return PseudoIterator.fromArray((GenericObject[])((GenericObject[])this.childs.toArray(new Item[this.childs.size()])));
    }

    public boolean hasChild(GenericObjectNode object) throws RemoteException {
        throw new UnsupportedOperationException("not implemented");
    }

    public GenericObjectNode getParent() throws RemoteException {
        return this.parent;
    }

    public GenericIterator getPossibleParents() throws RemoteException {
        throw new UnsupportedOperationException("not implemented");
    }

    public GenericIterator getPath() throws RemoteException {
        throw new UnsupportedOperationException("not implemented");
    }

    public Object getAttribute(String name) throws RemoteException {
        if ("name".equals(name)) {
            return this.getName();
        }
        return this.path.getAttribute(name, null);
    }

    public String getID() {
        String id = this.path.getAttribute("id", null);
        return id != null ? id : this.path.getFullName() + ":" + this.path.getLineNr();
    }

    @Override
    public String getExtendableID() {
        return this.getID();
    }

    public String getPrimaryAttribute() throws RemoteException {
        return "name";
    }

    public boolean equals(GenericObject other) throws RemoteException {
        if (other == null) {
            return false;
        }
        return this.getID().equals(other.getID());
    }

    public String[] getAttributeNames() throws RemoteException {
        return new String[]{"name"};
    }

    @Override
    public void addChild(Item i) throws RemoteException {
        if (i == null) {
            return;
        }
        this.childs.add(i);
    }
}

